/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xlatrig.h
 *       trace memory trigger functions
 * -----------------------------------------------------------------*/

#ifndef XLATRIG_H_INCLUDED
#define XLATRIG_H_INCLUDED

#include <xlatrdef.h>

#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
  Generic properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXTrigGenSet(   /* @triggenset */
  bx_handletype handle,                         
  bx_triggentype prop,                  
  bx_int32 val                        
);

CLI bx_errtype EXPORT BestXTrigGenGet(      /* @triggenget */
  bx_handletype handle,
  bx_triggentype prop,                     
  bx_int32  *val                            /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXTrigGenDefaultSet( /* @triggendefset */
  bx_handletype handle
);

/****************************************************************************
  TRAN properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXTrigTranSet(     /* @trigtranset    */
  bx_handletype handle, 
  bx_int32 offset,             
  bx_trigtrantype prop,     
  bx_int32 val                                
);   

CLI bx_errtype EXPORT BestXTrigTranGet(     /* @trigtranget    */
  bx_handletype handle, 
  bx_int32 offset,                   
  bx_trigtrantype prop,     
  bx_int32 *val                             /* #RETURN "0x%08lx" */   
);   

CLI bx_errtype EXPORT BestXTrigTranDefaultSet( /* @trigtrandefset */
  bx_handletype handle,
  bx_int32 offset  
);

/****************************************************************************
  COND properties ********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXTrigCondDefaultSet( /* @trigconddefset */
  bx_handletype handle,
  bx_int32 offset
);

CLI bx_errtype EXPORT BestXTrigCondSet(   /* @trigcondset   */
  bx_handletype handle,                       
  bx_int32 offset,     
  bx_trigcondtype prop, 
  bx_charptrtype cond
);

CLI bx_errtype EXPORT BestXTrigCondGet(   /* @trigcondget   */
  bx_handletype handle,                       
  bx_int32 offset,     
  bx_trigcondtype prop, 
  bx_charptrtype *cond                    /* #RETURN "\"%s\"" */
);



/****************************************************************************
  TRAN + COND properties ****************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXTrigTranCondDefaultSet( /* @trigtranconddefset */
  bx_handletype handle,
  bx_int32 offset  
);

CLI bx_errtype EXPORT BestXTrigDefaultSet(  /* @trigdefset */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXTrigProg(        /* @trigprog   */
  bx_handletype handle    
);

/****************************************************************************
  Helpers for GUI ***********************************************************
****************************************************************************/

CLI bx_errtype EXPORT BestXTrigMaxNumLinesGet( /* @trigmaxnumlinesget */
  bx_handletype handle,
  bx_int32 *val                                /* #RETURN "%lu" */
);

CLI bx_errtype EXPORT BestXTrigMaxNumLinesSet(  /* @trigmaxnumlinesset */
  bx_handletype handle,
  bx_int32 val
);



#ifdef __cplusplus
}
#endif


#endif



